package treeN;
import java.util.*;
import extvisitor.*;

/**
 * @dependency treeN.ITreeNAlgo uses
 */
public class TreeN<E> implements IExtVisitorHost<Integer, TreeN<E>> {
  /** @SBGen Collection of treeN.TreeN (,child trees,,64)   */
  private Vector<TreeN<E>> _children = new Vector<TreeN<E>>();
  private Vector<E> _data = new Vector<E>();
  
  public TreeN() {}
  
  public TreeN(E n) { this(new TreeN<E>(), n, new TreeN<E>());}
  
  private TreeN(Vector<E> data, Vector<TreeN<E>> children) {
    _data = data; _children = children;
  }
  
  private TreeN(TreeN<E> lTree, E n, TreeN<E> rTree) {
    _data.add(n); _children.add(lTree); _children.add(rTree);
  }
  
  public E getDat(int idx) { return _data.get(idx); }
  
  public TreeN<E> getChild(int idx) { return _children.get(idx); }
  
  /**
   * Splices a source tree into the tree at the supplied child tree index.
   * @param idx -- 0 &lt;= idx &lt;= state of the tree+1, unless state = 0 then idx must equal 0.
   * @param tree -- tree to be spliced in.   If the state of this tree = 0, then nothing is done.
   * @return
   */
  public TreeN<E> spliceAt(int idx, TreeN<E> tree) {
    int i=tree._data.size();
    if(i>0) { // do nothing if tree is empty.
      if(_data.size() > 0) {
        _children.set(idx, tree.getChild(i--));  // replace the tree @ idx
      }
      else { // receiver is empty
        _children.add(idx,tree.getChild(i--));  // idx must = 0
      }
      for(; i>=0;i--) {
        _data.add(idx,tree.getDat(i));
        _children.add(idx, tree.getChild(i));
      }
    }
    return this;
  }
  
  public TreeN<E> splitUpAt(int idx) {
    if(_data.size()>1) {
      TreeN lTree, rTree;
      Vector<E> newData = new Vector<E>();
      Vector<TreeN<E>> newChildren = new Vector<TreeN<E>>();
      E rootDat = _data.remove(idx);
      for(int i = 0;i<idx;i++) {
        newData.add(_data.remove(0));
        newChildren.add(_children.remove(0));
      }
      newChildren.add(_children.remove(0));
      if(newData.size()>0) lTree = new TreeN<E>(newData,newChildren);
      else lTree = newChildren.firstElement();
      if(_data.size()>0) rTree = new TreeN(_data, _children);
      else rTree = _children.firstElement();
      (_data = new Vector<E>()).add(rootDat);
      (_children = new Vector<TreeN<E>>()).add(lTree);
      _children.add(rTree);
    }
    return this;
  }
  
  public TreeN<E> splitDownAt(int idx) {
    if(_data.size()>1){
      TreeN<E> newChild = new TreeN<E>(getChild(idx),_data.remove(idx),getChild(idx+1));
      _children.remove(idx);
      _children.set(idx, newChild);
    }
    else {
      _data.clear();
      _children.clear();
    }
    return this;
  }
  
//  public R execute(ITreeNAlgo<E, R,P> algo, P... param) {
  public <R, P> R execute(IExtVisitor<R, Integer, P, TreeN<E>> algo,  P... params){
    return algo.caseAt(_data.size(), this, params);
  }
}

